/***************************************************************************
**
**  This file is part of gphistogram.
**
**  gphistogram is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gphistogram is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-08-21
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GaussianMixtureOutput.h"

/*!
  \class GaussianMixtureOutput GaussianMixtureOutput.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
GaussianMixtureOutput::GaussianMixtureOutput(QObject * parent)
  : QObject(parent)
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
GaussianMixtureOutput::~GaussianMixtureOutput()
{
  TRACE;
}

void GaussianMixtureOutput::newValues(int index)
{
  TRACE;
  Densities d=filter(index);
  double x=_densities->histogram()->x(index);
  RealStatisticalPoint p;
  QTextStream sOut(stdout);
  for(int i=0; i<d.count(); i++) {
    p.setX(x);
    p.setMean(d.density(i).mean());
    p.setStddev(d.density(i).stddev());
    p.setWeight(d.weight(i));
    sOut << p.toString() <<endl;
  }
}

Densities GaussianMixtureOutput::filter(int index) const
{
  TRACE;
  double x=_densities->histogram()->x(index);
  App::freeze(false);
  Densities d=_densities->densities(index);
  App::log(tr("Best misfit %1 at x %2 (model index %3 over %4)\n")
                   .arg(_densities->bestMisfit())
                   .arg(x)
                   .arg(_densities->bestMisfitIndex().value())
                   .arg(_densities->modelCount()));
  App::log(d.humanInfo("# "));
  // Remove extremely small modes. Risky to remove weights below 10% before filtering between kmin and kmax
  d.filterWeight(0.05);
  // Exclude outside kmin and kmax
  if(_densities->parameters().kmin()>0.0 && _densities->parameters().kmax()>_densities->parameters().kmin()) {
    // Remove 1% to account for precision errors in parameter discretization
    // We want to remove solution that at too close to limits
    d.filterRange(1.01*_densities->parameters().kmin(), 0.99*_densities->parameters().kmax());
  }
  // Small valid modes inside kmin and kmax have a slightly larger weight than before filtering between kmin and kmax
  d.filterWeight(0.1);
  App::freeze(true);
  return d;
}
