/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-13
**  Copyright: 2007-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SOURCEPARAMETERS_H
#define SOURCEPARAMETERS_H

#include <QtGui>
#include <QGpCoreWave.h>

class Simulator;

class SourceParameters: public XMLClass
{
  TRANSLATIONS("SourceParameters")
public:
  SourceParameters();
  ~SourceParameters() {}

  virtual const QString& xml_tagName() const {return xmlSourceParametersTag;}
  static const QString xmlSourceParametersTag;

  enum WaveModel {PlaneWaves, CircularWaves};

  const QString& name() const {return _name;}
  void setName(const QString& n) {_name=n;}

  const Point2D& sourcePoint() const {return _sourcePoint;}
  void setSourcePoint(const Point& s) {_sourcePoint=s;}
  void setSourceX(double x) {_sourcePoint.setX(x);}
  void setSourceY(double y) {_sourcePoint.setY(y);}

  double azimuth(WaveModel wm) const;
  double azimuthMath(WaveModel wm) const;
  double azimuthMath(WaveModel wm, const Point2D& to) const;
  void setAzimuth(WaveModel wm, double a);

  double distance() const;
  void setDistance(double d);

  double amplitude() const {return _amplitude;}
  void setAmplitude(double a) {_amplitude=a;}

  double phase() const {return _phase;}
  void setPhase(double p) {_phase=p;}

  double velocity() const {return _velocity;}
  void setVelocity(double v) {_velocity=v;}

  double ellipticity() const {return _ellipticity;}
  void setEllipticity(double v) {_ellipticity=v;}

  Mode::Polarization polarization() const {return _polarization;}
  void setPolarization(Mode::Polarization p) {_polarization=p;}

  const Color& color() const {return _color;}
  void setColor(const Color& c) {_color=c;}
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _name;
  Point2D _sourcePoint;
  Mode::Polarization _polarization;
  double _azimuth;
  double _amplitude;
  double _phase;
  double _velocity;
  double _ellipticity;
  Color _color;
};

#endif // SOURCEPARAMETERS_H
