/***************************************************************************
**
**  This file is part of gpdc.
**
**  gpdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-03
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "DispersionReader.h"
#include "gpdcVersion.h"
#include "gpdcInstallPath.h"

PACKAGE_INFO("gpdc", GPDC)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  // Options
  DispersionReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILES]" );
  h->setComments( "Compute dispersion curves for layered models given through stdin or FILES.\n\n"
                 "Format for layered models:\n"
                 + Seismic1DModel::formatHelp() +
                 "\n\n"
                 "Quality factors are not mandatory. If not specified, pure elastic computation is performed. Any number of models "
                 "can be given as input.");
  h->addGroup("Gpdc","gpdc");
  h->addOption("-step <s>","Step between frequencies (default=1.025 for log scale)");
  h->addOption("-n <count>","Number of samples (default=use step to get number of samples)");
  h->addOption("-L <n modes>","Number of Love modes (default=0)");
  h->addOption("-R <n modes>","Number of Rayleigh modes (default=1)");
  h->addOption("-one-mode","Instead of outputting all modes (see options '-R' and '-L'), output only the highest one.");
  h->addOption("-f","Does not return immediately if dispersion curve cannot be calculated.");
  h->addOption("-grid <L | R>","Ouput a grid of the wave solutions (not set by default). "
                              "The letter L or R stands for Love or Rayleigh.");
  h->addOption("-group","Switches to group slowness (default=phase)");
  h->addOption("-s <sampling>","Defines the sampling type:\n"
                              "  period     regular sampling in period\n"
                              "  frequency  regular sampling in frequency\n"
                              "  log        regular sampling in log(frequency) (default)");
  h->addOption("-min <min>","Minimum of range for dispersion curve (default=0.2)");
  h->addOption("-max <max>","Maximum of range for dispersion curve (default=20)");
  h->addOption("-vn <count>","Number of velocity samples (only for -grid, default=100)");
  h->addOption("-vmin <min>","Minimum of range for velocity (only for -grid, default=100)");
  h->addOption("-vmax <max>","Maximum of range for velocity (only for -grid, default=3000)");
  h->addOption("-delta-k","Computes wavenumber gaps between modes. Number of modes must be at least 2.");
  h->addOption("-half-space <index>", "Take Vp and Vs from layer index and compute the Rayleigh phase slowness for a half-space with these Vp and Vs.");
  h->addExample("gpdc < test.model", "Calculate fundamental Rayleigh dispersion curve from 0.2 Hz to 20 Hz for model 'test.model'.");
  h->addExample("gpdc -L 1 -R 2 < test.model", "Calculate fundamental Love mode and fundamental and first higher mode for Rayleigh.");
  h->addExample("gpdc < test.model | figue -c", "Calculate the same dispersion curve and plot it.");
  h->addExample("gpdc < test.model | figue -c -m dc.mkup", "Show the same dispersion curve on a log-log plot. 'dc.mkup' is a tar.gz file containing an xml description of the graphic format, it can be generated from figue's interface.");
  h->setSeeAlso("gpell, gpprofile");
  return h;
}
