/***************************************************************************
**
**  This file is part of gpcurve.
**
**  gpcurve is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpcurve is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-11
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CURVEREADER_H
#define CURVEREADER_H

#include <QGpCoreMath.h>

class CurveReader : public ArgumentStdinReader
{
  TRANSLATIONS("ArgumentStdinReader")
public:
  CurveReader();

  bool setOptions(int& argc, char ** argv);
  bool isFunctionMode() const {return _mode==ParseFunction;}
  void generateFunction() const;
  bool terminate();
protected:
  virtual bool parse(QTextStream& s);
private:
  bool exec(Curve<PointND>& curve);
  bool loadReference();

  enum Mode {None, Resample, ResampleExtrapole, Cut, CutInterpole, Swap, Regression, FunctionValue,
             MaxIndex, MaxValue, MinIndex, MinValue, LocalMax, LocalMaxIndex, LocalMaxValue,
             LocalMin, LocalMinIndex, LocalMinValue,
             Misfit, MergeReplace, MergeInterpolate, Split, ParseFunction, Derivative, Curvature, Angles,
             Multiply, Log, Power, MinMax, Extrapolate, Smooth};
  Mode _mode;
  int _nResample;
  double _minX;
  double _maxX;
  double _splitMaxX;
  double _splitMaxErr;
  int _splitMinCount;
  double _dx;
  double _xValue;
  int _columnIndex;
  SamplingOption _samplingType;
  QString _referenceFile;
  Curve<PointND> _referenceCurve;
  MisfitType _misfitType;
  double _misfitMin;
  int _misfitDof;
  QString _functionText;
  double _logBase;
  double _multiplyFactor;
  Curve<PointND> _minCurve, _maxCurve;
};

#endif // CURVEREADER_H
