/***************************************************************************
**
**  This file is part of gpcoord.
**
**  gpcoord is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpcoord is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-19
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COORDREADER_H
#define COORDREADER_H

#include <QGpCoreTools.h>
#include <TapePositioningSystem.h>

class CoordReader : public ArgumentStdinReader
{
  TRANSLATIONS("CoordReader")
public:
  CoordReader();
  ~CoordReader();

  bool setOptions(int& argc, char ** argv);
  bool hasInput() const;
  bool terminate();
protected:
  virtual bool parse(QTextStream& s);
private:
  enum Mode {None, Distance, DistanceLookup, DistanceGeo, Azimuth, AzimuthGeo, FromGeo, ToGeo, FromDMS, ToDMS, FromDM, ToDM,
             ToUTM, FromUTM, ToKML, FromKML, Translate, Rotate, Average, Localize, Lookup, TriangulateDistance, TriangulateAzimuth,
             FromDistances, GenerateCircle, ArrayLimits, UTMDeclination, MagDeclination, AllDistances};
  enum FromDistancesOutMode {NoOutput=0, Mean=1, Raw=2, Ellipse=4, Clusters=8};
  Mode _mode;
  FromDistancesOutMode _fromDistancesOutMode;
  Point _geoReference;
  Point _cartReference;
  Angle _angle;
  Point _translateVector;
  Point _average;
  int _averageCount;
  QVector<Point2D> _array;
  QMap<QString, Point> _refPoints;
  QVector<Circle> _circles;
  QVector<Line2D> _lines;
  QDate _date;
  GoogleEarthKML * _kml;
  QString _kmlFileName;
  UtmZone _utmZone;
  QString _origin, _north, _eastward;
  double _distanceStddev, _priorPrecision, _posteriorPrecision;
  Triangulator _fromDistanceFactory;
  int _clusterCount;
  ConsoleProgress * _progress;
};

#endif // COORDREADER_H
