/***************************************************************************
**
**  This file is part of geopsyptmotion.
**
**  geopsyptmotion is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyptmotion is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-11-13
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QRadioButton>

#include <GeopsyCore.h>
#include <GeopsyGui.h>
#include <QGpGuiTools.h>
#include "ToolPtMotion.h"
#include "ToolPtMotiond.h"
#include "PtMotionResults.h"

#define _ptMotionRes ((PtMotionResults*)_childrenList[0])

ToolPtMotion::ToolPtMotion(QWidget * parent) :
  AbstractToolWidget(parent, 1)
{
  TRACE;
  QVBoxLayout * baseLayout=new QVBoxLayout(this);
  _d=new ToolPtMotiond(this);
  baseLayout->addWidget(_d);
  setWindowTitle(tr("Particle motion toolbox"));
  setObjectName("ToolPtMotion");
}

void ToolPtMotion::updateAllFields()
{
  TRACE;
  _d->on_doFilterBut_stateChanged();
  _d->filterWidget->updateAllFields();
  _d->on_vertical_toggled();
  _d->timeLimits->updateAllFields();
  updateSignals();
}

bool ToolPtMotion::initStations(SubSignalPool * subPool)
{
  TRACE;
  if(!subPool->associate3Components()) return false;
  _d->timeLimits->setSubPool(subPool);
  _childrenList[0]=new PtMotionResults;
  _ptMotionRes->setObjectName("ToolPtMotionResults");
  _ptMotionRes->createObjects(subPool);
  if(pickLayer()) {
    connect(pickLayer(), SIGNAL(pickChanged(Signal *, QString)), _d->timeLimits, SLOT(updatePicks()));
  }
  GeopsyGuiEngine::instance()->addSubWindow(this, _ptMotionRes)->setUserClosable(false);

  connect(_d->updateAxisBut, SIGNAL(stateChanged(int)), this, SLOT(setLimits()));
  connect(_d->vertical,SIGNAL(toggled(bool)), this,SLOT(updateSignals()));
  connect(_d->azimuth,SIGNAL(valueChanged(double)), this,SLOT(updateSignals()));
  connect(_d->doFilterBut,SIGNAL(stateChanged(int)), this,SLOT(updateSignals()));
  connect(_d->filterWidget,SIGNAL(parametersChanged()), this,SLOT(updateSignals()));
  connect(_d->timeLimits,SIGNAL(parametersChanged()), this,SLOT(updateSignals()));
  connect(_d->plotLinesBut,SIGNAL(stateChanged(int)), this,SLOT(updateSignals()));

  updateSignals();
  _ptMotionRes->setLimits();
  return true;
}

void ToolPtMotion::updateSignals()
{
  TRACE;
  bool doFilter=_d->doFilterBut->isChecked();
  FilterParameters fparam;
  _d->filterWidget->getParameters(fparam);
  TimeRangeParameters tlparam;
  _d->timeLimits->getParameters(tlparam);
  _ptMotionRes->updateSignals(subPool(), tlparam, doFilter, fparam, _d->vertical->isChecked(), _d->azimuth->value());
  _ptMotionRes->setPlotOtions(_d->plotLinesBut->isChecked());
  setLimits();
}

void ToolPtMotion::setLimits()
{
  TRACE;
  if(_d->updateAxisBut->isChecked()) {
    _ptMotionRes->setLimits();
  }
}
