/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-11-13
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "GeopsyHVPrefs.h"

GeopsyHVPrefs hvPrefs;

GeopsyHVPrefs::GeopsyHVPrefs()
{
  TRACE;
  // Load preferences from registry
  load();
  save();
}

GeopsyHVPrefs::~GeopsyHVPrefs()
{
  TRACE;
}

void GeopsyHVPrefs::load()
{
  TRACE;
  QSettings& reg=CoreApplication::instance()->settings();
  reg.beginGroup("DialogOptions");
  reg.beginGroup("Preferences");
  reg.beginGroup("preferenceTab");
  reg.beginGroup("qt_tabwidget_stackedwidget");
  reg.beginGroup("TabHVPreferences");

  reg.beginGroup("hvOptions");
  reg.beginGroup("visibleLayerGroup");
  _hvVisibleLayers=0;
  if(reg.value("t10",true).toBool()) _hvVisibleLayers |= 0x01;
  if(reg.value("frequencyPeaks",true).toBool()) _hvVisibleLayers |= 0x02;
  if(reg.value("allWindows",true).toBool()) _hvVisibleLayers |= 0x04;
  if(reg.value("average",true).toBool()) _hvVisibleLayers |= 0x08;
  if(reg.value("stddev",true).toBool()) _hvVisibleLayers |= 0x10;
  reg.endGroup();
  reg.endGroup();

  reg.beginGroup("spectrumOptions");
  reg.beginGroup("visibleLayerGroup");
  _spectrumVisibleLayers=0;
  if(reg.value("t10",true).toBool()) _spectrumVisibleLayers |= 0x01;
  if(reg.value("frequencyPeaks",false).toBool()) _spectrumVisibleLayers |= 0x02;
  if(reg.value("allWindows",true).toBool()) _spectrumVisibleLayers |= 0x04;
  if(reg.value("average",true).toBool()) _spectrumVisibleLayers |= 0x08;
  if(reg.value("stddev",true).toBool()) _spectrumVisibleLayers |= 0x10;
}

void GeopsyHVPrefs::save()
{
  TRACE;
  QSettings& reg=CoreApplication::instance()->settings();
  reg.beginGroup("DialogOptions");
  reg.beginGroup("Preferences");
  reg.beginGroup("preferenceTab");
  reg.beginGroup("qt_tabwidget_stackedwidget");
  reg.beginGroup("TabHVPreferences");

  reg.beginGroup("hvOptions");
  reg.beginGroup("visibleLayerGroup");
  reg.setValue("t10", _hvVisibleLayers & 0x01);
  reg.setValue("frequencyPeaks", _hvVisibleLayers & 0x02);
  reg.setValue("allWindows", _hvVisibleLayers & 0x04);
  reg.setValue("average", _hvVisibleLayers & 0x08);
  reg.setValue("stddev", _hvVisibleLayers & 0x10);
  reg.endGroup();
  reg.endGroup();

  reg.beginGroup("spectrumOptions");
  reg.beginGroup("visibleLayerGroup");
  reg.setValue("t10", _spectrumVisibleLayers & 0x01);
  reg.setValue("frequencyPeaks", _spectrumVisibleLayers & 0x02);
  reg.setValue("allWindows", _spectrumVisibleLayers & 0x04);
  reg.setValue("average", _spectrumVisibleLayers & 0x08);
  reg.setValue("stddev", _spectrumVisibleLayers & 0x10);
}
