/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-03-07
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SigSelectionDnD_H
#define SigSelectionDnD_H

#include <QtGui>

#include <GeopsyCore.h>

class SigSelectionDnD :  public QObject
{
  Q_OBJECT
public:
  SigSelectionDnD(QWidget * eventSource);

  bool eventFilter(QObject *, QEvent * event);
  void setDragEnabled(bool b) {_dragEnabled=b;}
  void setDropEnabled(bool b);
  QWidget * source() {return _src;}
public slots:
  void enableFilter();
  void disableFilter();
signals:
  void acceptDrop(const QPoint& pos, bool& ok);
  void getSelection(SubSignalPool& sel);
  void selectionDropped(QWidget * parent, const SubSignalPool& sel);
protected:
  virtual bool dragEnterEvent(QDragEnterEvent * e);
  virtual bool dragMoveEvent(QDragMoveEvent * e);
  virtual bool dropEvent(QDropEvent * e);
  virtual bool mousePressEvent(QMouseEvent * e);
  virtual bool mouseReleaseEvent(QMouseEvent * e);
  virtual bool mouseMoveEvent(QMouseEvent * e);

  QWidget * _src;
  QPoint _mousePressPos;
  bool _dropEnabled;
  bool _dragEnabled;
  enum DragState {Idle, Pressed, Dragging};
  DragState _state;
  bool _filterEnabled;
};

#endif
