/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-08-30
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SEISMICEVENTVIEW_H
#define SEISMICEVENTVIEW_H

#include <GeopsyGui.h>

class SeismicEventView : public QTableView
{
  Q_OBJECT
public:
  SeismicEventView(QWidget * parent=nullptr);
  ~SeismicEventView();

  void addActions();
private slots:
  void addEvent();
  void removeEvents();
  void importEvents();
  void exportEvents();
  void applyAllSelected();
protected:
  void contextMenuEvent(QContextMenuEvent * e);
  bool event(QEvent *event);
private:
  QList<SeismicEvent *> getSelection() const;
  inline SeismicEventItem * model() const;

  QMenu * _menu;
};

#endif // SEISMICEVENTVIEW_H

