/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-19
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef LOADFILEPATTERN_H
#define LOADFILEPATTERN_H

#include <QGpGuiTools.h>

#include "ui_LoadFilePattern.h"

class LoadFilePattern : public Dialog, private Ui::LoadFilePattern
{
  Q_OBJECT
public:
  LoadFilePattern(QWidget * parent=nullptr);
  ~LoadFilePattern();

  void saveHistory();
  QString baseDirectory() const {return baseDirectoryEdit->text();}
  QString filePattern() const {return filePatternEdit->currentText();}
private slots:
  void on_browseDirectories_clicked();
};

#endif // LOADFILEPATTERN_H
