/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-12-22
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef INSTRUMENTALRESPONSEWIDGET_H
#define INSTRUMENTALRESPONSEWIDGET_H

#include <SciFigs.h>
#include <GeopsyCore.h>

#include "ui_InstrumentalResponseWidget.h"

class InstrumentalResponseWidget : public Dialog, private Ui::InstrumentalResponseWidget
{
  Q_OBJECT
public:
  InstrumentalResponseWidget(QWidget * parent=nullptr);
  ~InstrumentalResponseWidget();

  const InstrumentalResponse& response() const {return _response;}
  void setResponse(const InstrumentalResponse& resp);
public slots:
  bool load(QString fileName=QString());
  bool save(QString fileName=QString());
private slots:
  void on_sensorFile_editTextChanged(const QString& text);
  void on_addPoleButton_clicked();
  void on_removePoleButton_clicked();
  void on_addZeroButton_clicked();
  void on_removeZeroButton_clicked();
  void updatePlots();
  void on_transferMode_currentIndexChanged(int index);
  void on_nameEdit_textChanged(QString text);
  void on_noiseEdit_textChanged(QString text);
  void on_transductionEdit_textChanged(QString text);
  void on_normalizationEdit_textChanged(QString text);
  void on_frequencyEdit_currentIndexChanged(int index);
private:
  void setTransferPlotLimits();

  InstrumentalResponse _response;
  LineLayer * _transfer;
};

#endif // INSTRUMENTALRESPONSEWIDGET_H

