/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-04-13
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CHRONOGRAMWINDOW_H
#define CHRONOGRAMWINDOW_H

#include <GeopsyGui.h>

class ChronogramWindow : public SubPoolWindow
{
  Q_OBJECT
public:
  ChronogramWindow(QWidget* parent=nullptr);
  ~ChronogramWindow();

  virtual void setWindowTitle(QString title);
  virtual void subPoolUpdate();
  virtual void fastFourierTransform(DoubleSignal::SignalType st);

  ChronogramLayer * chronogramLayer() const {return _chronogramLayer;}

  void setLimits();
  void updateLabels();
public slots:
  void getSelection(SubSignalPool& sel);
  virtual void endSignalChange(Signal * sig=nullptr);
protected:
  virtual void focusInEvent(QFocusEvent * e);
private:
  ChronogramLayer * _chronogramLayer;
};

#endif // CHRONOGRAMWINDOW_H
