/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMLAYERWIDGET_H
#define PARAMLAYERWIDGET_H

#include <DinverCore.h>
#include <DinverDCCore.h>
#include <DinverGui.h>

#include "ui_ParamLayerWidget.h"

class ParamProfileWidget;

class ParamLayerWidget : public QWidget, public Ui::ParamLayerWidget
{
  Q_OBJECT
public:
  ParamLayerWidget(QWidget *parent=nullptr);
  ~ParamLayerWidget();

  QString name();
  int index() {return _index;}
  ParamLayer * paramLayer(ParamProfile * profile);
  bool tilted() const;
  bool isDepth() const;
  void setEditable(bool e);
public slots:
  void setProfile(ParamProfileWidget * p, ParamLayerWidget * v);
  void setIndex(int index);
  void on_shape_activated(int);
  void on_depthThickness_activated(int);
  void on_linkedTo_activated(int);
  bool isSelected();
  void on_selected_clicked();
  void on_selected_toggled(bool);
  void setDHLinks(QStringList & links);
  void setFrom(ParamLayer * p);
  void setLinksFrom(ParamLayer * p);
  void setCurrentLink(QString link);
signals:
  void wantToBeSelected();
  void updateDHLinks();

protected:
  ParamProfileWidget * _profile;
  int _index;
};

#endif // QTBPARAMLAYERWIDGET_H
