/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-08
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <DinverCore.h>

#include "MainWindow.h"
#include "InversionThread.h"
#include "XMLDinverGui.h"

/*!
  \class XMLDinverGui XMLDinverGui.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

XMLDinverGui::XMLDinverGui(MainWindow * w)
  : XMLDinver(w->plugin())
{
  TRACE;
  _window=w;
}

void XMLDinverGui::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  XMLDinver::xml_writeChildren(s, context);
  XMLDinverContext * dinverContext=static_cast<XMLDinverContext *>(context);
  if(dinverContext->all()) {
    ThreadList ts=_window->threads();
    for(ThreadList::const_iterator it=ts.begin();it!=ts.end();++it) {
      (*it)->xml_save(s, context);
    }
  }
}

XMLMember XMLDinverGui::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  XMLDinverContext * dinverContext=static_cast<XMLDinverContext *>(context);
  if(tag=="InversionThread") {
    if(dinverContext->all()) {
      InversionThread * t=new InversionThread(_window);
      _window->addThread(t);
      StreamRedirection sr(App::stream(t));
      AbstractForward * f=_window->plugin()->createForward();
      if(f) {
        t->setForward(f);
        delete f; // InversionThread keeps a clone of f
        return XMLMember(t);
      } else {
        App::log(tr("Error creating a new forward object, skipping run\n") );
        return XMLMember(XMLMember::Skip);
      }
    } else {
      return XMLMember(XMLMember::Skip);
    }
  } else return XMLDinver::xml_member(tag, attributes, context);
}
