/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-06
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PLUGINSELECTOR_H
#define PLUGINSELECTOR_H

#include <QGpGuiTools.h>
#include <DinverCore.h>

#include "ui_PluginSelector.h"

class PluginSelector : public Dialog, public Ui::PluginSelector
{
  Q_OBJECT
public:
  PluginSelector(QWidget * parent=0, bool debug=false);
  ~PluginSelector();

  QString file() const;
public slots:
  void on_searchPaths_clicked();
  void on_pluginList_itemChanged (QListWidgetItem * selItem);
protected:
  bool setLibList(QStringList libs);
  QStringList _pluginFileList;
  static const char * _noticeContents;
  bool _wrongBuildKey;
  bool _debug;
};

#endif // PLUGINSELECTOR_H
