/***************************************************************************
**
**  This file is part of campbelltob3.
**
**  campbelltob3 is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  campbelltob3 is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-12-18
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CAMPBELLLOADER_H
#define CAMPBELLLOADER_H

#include <QGpGuiTools.h>

#include "Tob3Scanner.h"
#include "ui_CampbellLoader.h"

class CampbellLoader : public Dialog, private Ui::CampbellLoader
{
  Q_OBJECT
public:
  CampbellLoader(QWidget * parent=nullptr);
  ~CampbellLoader();
public slots:
  void scan();
private slots:
  void setTimeLimits(QModelIndex index);
  void on_inputBrowse_clicked();
  void startTimeReady();
  void on_loadBut_clicked();
private:
  Tob3Scanner * _scanner;
  QList< QPair<QString, SignalFileFormat> > _formats;
};

#endif // CAMPBELLLOADER_H
