/***************************************************************************
**
**  This file is part of TapePositioningSystem.
**
**  TapePositioningSystem is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  TapePositioningSystem is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-12-05
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ANCHORAGE_H
#define ANCHORAGE_H

#include <QtCore>

#include "TapePositioningSystemDLLExport.h"

namespace TapePositioningSystem {

  class Node;

  class TAPEPOSITIONINGSYSTEM_EXPORT Anchorage
  {
  public:
    Anchorage() {_newNode=0;}
    ~Anchorage() {}

    void addAnchor(Node * n) {_anchors.append(n);}
    void setNewNode(Node * n) {_newNode=n;}
    bool isValidAnchor() const {return _anchors.count()==3;}

    Node * n() const {return _newNode;}
    Node * a() const {return _anchors.at(0);}
    Node * b() const {return _anchors.at(1);}
    Node * c() const {return _anchors.at(2);}
  private:
    QVector<Node *> _anchors;
    Node * _newNode;
  };

} // namespace TapePositioningSystem

#endif // ANCHORAGE_H
