/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-07
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PlotLine.h"
#include "LineFactory.h"

namespace SciFigs {

/*!
  \class PlotLine PlotLine.h
  \brief A PlotLine is a vector of points with appearance properties

  Each point is of type Point which has 3 components: x, y and error
  on y (z component of Point). Appearance properties are the Pen and the
  QbtSymbol used to draw line segments between points and the symbol at each
  point, respectively. An additionnal property is a boolean to tell whether the
  point is selected or not.
*/

REGISTER_LINE(PlotLine, "Line" );
// Compatibility
SYNONYM_LINE(DynLine, "Line" );
SYNONYM_LINE(DynLine2D, "Line" );

AbstractLine * PlotLine::clone() const
{
  PlotLine * l=new PlotLine;
  *l=*this;
  return l;
}

void PlotLine::operator=(const PlotLine& o)
{
  _curve=o._curve;
  AbstractLine::operator=(o);
}

#if 0
TODO: move it to Curve
void PlotLine::setCurve(QVector<double> * dataX, QVector<double> * dataY, QVector<double> * dataDY)
{
  TRACE;
  int n;
  if(dataX) n=dataX->size(); else n=0;
  if(n > 0) {
    _curve.resize(n);
    for(int j=0;j < n;j++ ) {
      Point& p=_curve[ j ];
      p.setX(dataX->at(j) );
      p.setY(dataY->at(j) );
      if(dataDY) p.setZ(dataDY->at(j) ); else p.setZ(0.0);
    }
  }
}
#endif

} // namespace SciFigs
