/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-05
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MESHLAYER_H
#define MESHLAYER_H

#include "GraphContentLayer.h"

namespace SciFigs {

  class SCIFIGS_EXPORT MeshLayer : public GraphContentLayer
  {
    Q_OBJECT
  public:
    MeshLayer(AxisWindow * parent);
    ~MeshLayer();

    void setStep(double s);
    double step() const {return _step;}

    void setSize(double s);
    double size() const {return _size;}

    virtual Rect boundingRect() const;
  protected:
    virtual void paintData (const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  private:
    double _step, _size, _size0;
    double _dotSize; // point size in cm
  };

} // namespace SciFigs

#endif // MESHLAYER_H
