/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2002-10-03
**  Copyright: 2002-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDITEM_H
#define LEGENDITEM_H

#include "Pen.h"
#include "Symbol.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT LegendItem : public XMLClass
{
public:
  LegendItem() {}
  inline LegendItem(const QString& t, const Pen& p, const Symbol& s);
  virtual ~LegendItem() {}

  LegendItem& operator=(const LegendItem& o);
  bool operator==(const LegendItem& o) const;
  bool operator!=(const LegendItem& o) const {return !operator==(o);}

  virtual const QString& xml_tagName() const {return xmlLegendItemTag;}
  static const QString xmlLegendItemTag;

  const QString& text() const {return _text;}
  const QColor& textColor() const {return _textColor;}
  Pen& pen() {return _pen;}
  const Pen& pen() const {return _pen;}
  Symbol& symbol() {return _symbol;}
  const Symbol& symbol() const {return _symbol;}
  void setText(const QString& t) {_text=t;}
  void setTextColor(const QColor& c) {_textColor=c;}
  void setPen(const Pen& p) {_pen=p;}
  void setSymbol(const Symbol& s) {_symbol=s;}
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
protected:
  QString _text;
  QColor _textColor;
  Pen _pen;
  Symbol _symbol;
};

inline LegendItem::LegendItem(const QString& t, const Pen& p, const Symbol& s)
{
  TRACE;
  _text=t;
  _pen=p;
  _symbol=s;
}


} // namespace SciFigs

#endif // LEGENDITEM_H
