/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-12-19
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HistogramLayer.h"
#include "GraphContentLayerFactory.h"
#include "LayerPainterRequest.h"
#include "XMLSciFigs.h"
#include "LayerLocker.h"

namespace SciFigs {

  /*!
    \class HistogramLayer HistogramLayer.h
    \brief Show step lines


  */

  const QString HistogramLayer::xmlHistogramLayerTag="HistogramLayer";

  REGISTER_GRAPHCONTENTLAYER(HistogramLayer, "HistogramLayer");

  /*!
    Description of constructor still missing
  */
  HistogramLayer::HistogramLayer(AxisWindow * parent)
    : LineLayer(parent)
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  HistogramLayer::~HistogramLayer()
  {
    TRACE;
  }

  void HistogramLayer::drawCurve(const GraphContentOptions& gc, QPainter& p, double dotpercm, int ,
                                 Rect& , const AbstractLine& line, int startAt, int endAt) const
  {
    TRACE;
    int zero=gc.yr2s(0.0);
    QPoint * path=new QPoint[endAt];
    path[startAt]=gc.r2s(line.point(startAt, _pointOptions));
    for(int j=startAt+1; j<endAt; j++) {
      path[j]=gc.r2s(line.point(j, _pointOptions));
    }
    const QPen& pen=line.pen().qpen(dotpercm);
    const QBrush& brush=line.symbol().brush();
    // First fill rects
    if(brush.style()!=Qt::NoBrush) {
      int penWidth=qCeil(pen.width()*0.5);
      if(penWidth==0) {
        penWidth=1;
      }
      for(int j=startAt+1; j<endAt; j++) {
        QPoint& p1=path[j-1];
        QPoint& p2=path[j];
        if(p1.y()!=zero) {
          if(gc.ay()<0) {
            p.fillRect(QRect(p1.x(), p1.y(), p2.x()-p1.x(), zero-p1.y()), brush);
          } else {
            p.fillRect(QRect(p1.x(), zero, p2.x()-p1.x(), p1.y()-zero), brush);
          }
        }
      }
    }
    // Second draw contour
    if(pen.style()!=Qt::NoPen) {
      p.setPen(pen);
      QPolygon ap(2*(endAt-startAt)-1);
      QPoint& p1=path[startAt];
      ap.setPoint(0, p1.x(), p1.y());
      for(int j=startAt+1; j<endAt; j++) {
        QPoint& p1=path[j-1];
        QPoint& p2=path[j];
        int i=2*(j-startAt)-1;
        ap.setPoint(i, p2.x(), p1.y());
        ap.setPoint(i+1, p2.x(), p2.y());
      }
      p.drawPolyline(ap.data(), ap.count());
    }
  }


} // namespace SciFigs
