/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRIDMAXFOLLOWER_H
#define GRIDMAXFOLLOWER_H

#include "LineLayer.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class IrregularGrid2DPlot;

class SCIFIGS_EXPORT GridMaxFollower : public LineLayer
{
  Q_OBJECT
public:
  GridMaxFollower(IrregularGrid2DPlot * grid, AxisType axis);

  virtual bool hasProperties() {return true;}
  virtual void addProperties(PropertyProxy * pp);
private slots:
  void adjustLine();
private:
  IrregularGrid2DPlot * _grid;
  AxisType _axis;
};

} // namespace SciFigs

#endif // GRIDMAXFOLLOWER_H
