/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-15
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COLORPALETTEEDITOR_H
#define COLORPALETTEEDITOR_H

#include <QGpCoreMath.h>

#include "ui_ColorPaletteEditor.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT ColorPaletteEditor : public QWidget, private Ui::ColorPaletteEditor
  {
    Q_OBJECT
  public:
    ColorPaletteEditor(QWidget * parent=nullptr);
    ~ColorPaletteEditor();

    void setPalette(AbstractColorPalette * pal);

    ColorPalette::Model currentModel();
  private slots:
    void on_interpole_clicked();
    void on_colorScale_clicked();
    void on_grayScale_clicked();
  signals:
    void beginPaletteChange();
    void endPaletteChange();
  private:
    AbstractColorPalette * _palette;
  };

} // namespace SciFigs

#endif // COLORPALETTEEDITOR_H

