/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-15
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ColorPaletteEditor.h"
#include "ListInterpole.h"

namespace SciFigs {

  /*!
    \class ColorPaletteEditor ColorPaletteEditor.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ColorPaletteEditor::ColorPaletteEditor(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    setupUi(this);
    _palette=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  ColorPaletteEditor::~ColorPaletteEditor()
  {
    TRACE;
  }

  void ColorPaletteEditor::setPalette(AbstractColorPalette * pal)
  {
    TRACE;
    _palette=pal;
  }

  ColorPalette::Model ColorPaletteEditor::currentModel()
  {
    TRACE;
    switch(model->currentIndex()) {
    case 0:
      return ColorPalette::Hobi;
    case 1:
      return ColorPalette::Hsv;
    case 2:
      return ColorPalette::McNames;
    case 4:
      return ColorPalette::Sardine;
    case 5:
      return ColorPalette::ColdHot;
    default:
      return ColorPalette::McNamesClip;
    }
  }

  void ColorPaletteEditor::on_interpole_clicked()
  {
    TRACE;
    ListInterpole * d=new ListInterpole(QApplication::activeWindow());
    emit beginPaletteChange();
    d->setColors(_palette->palette());
    Settings::getWidget(d);
    if(d->exec()==QDialog::Accepted) {
      Settings::setWidget(d);
      // TODO: interpole take current model into account
      _palette->hsvInterpole(d->fromIndex(), d->toIndex());
    }
    emit endPaletteChange();
    delete d;
  }

  void ColorPaletteEditor::on_colorScale_clicked()
  {
    TRACE;
    emit beginPaletteChange();
    _palette->generateColorScale(_palette->count(), currentModel(), reversed->isChecked());
    emit endPaletteChange();
  }

  void ColorPaletteEditor::on_grayScale_clicked()
  {
    TRACE;
    emit beginPaletteChange();
    _palette->generateGrayScale(_palette->count(), currentModel(), reversed->isChecked());
    emit endPaletteChange();
  }

} // namespace SciFigs

