/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-10-18
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef AUTOADJUSTSCALE_H
#define AUTOADJUSTSCALE_H

#include <QGpGuiTools.h>
#include <QGpCoreMath.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT AutoAdjustScale
  {
  public:
    AutoAdjustScale();
    AutoAdjustScale(const AutoAdjustScale& o);

    ~AutoAdjustScale() {}

    bool autoAdjust() const {return _autoAdjust;}
    void setAutoAdjust(bool a) {_autoAdjust=a;}

    bool forceMinimumValue() const {return _forceMinimumValue;}
    void setForceMinimumValue(bool f) {_forceMinimumValue=f;}

    double minimumValue() const {return _minimumValue;}
    void setMinimumValue(double m) {_minimumValue=m;}

    bool forceMaximumValue() const {return _forceMaximumValue;}
    void setForceMaximumValue(bool f) {_forceMaximumValue=f;}

    double maximumValue() const {return _maximumValue;}
    void setMaximumValue(double m) {_maximumValue=m;}

    bool forceRatio() const {return _forceRatio;}
    void setForceRatio(bool f) {_forceRatio=f;}

    bool symetric() const {return _symetric;}
    void setSymetric(bool f) {_symetric=f;}

    double ratio() const {return _ratio;}
    void setRatio(double r) {_ratio=r;}

    SamplingParameters::ScaleType scale() const {return _scale;}
    void setScale(SamplingParameters::ScaleType s) {_scale=s;}

    void properties(PropertyWidget * w) const;
    void setProperty(int pid, QVariant val);
  private:
    uint _autoAdjust:1;
    uint _forceMinimumValue:1;
    uint _forceMaximumValue:1;
    uint _forceRatio:1;
    uint _symetric:1;
    SamplingParameters::ScaleType _scale;
    double _minimumValue, _maximumValue, _ratio;
  };

} // namespace SciFigs

#endif // AUTOADJUSTSCALE_H

