/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-29
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>
#include <QGpCoreWave.h>

#include "ModeSelector.h"
#include "ModeItem.h"

namespace QGpGuiWave {

  /*!
    \class ModeSelector ModeSelector.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ModeSelector::ModeSelector(QWidget * parent)
      : QWidget(parent)
  {
    TRACE;
    setupUi(this);

    list->setModel(new ModeItem(this));
    list->setSelectionBehavior(QAbstractItemView::SelectItems);
    list->setSelectionMode(QAbstractItemView::ExtendedSelection);
    list->setEditTriggers(QAbstractItemView::AllEditTriggers);
    list->setItemDelegate(new ModeDelegate(this));
    list->resizeColumnsToContents();
    Settings::columnWidth(list, "ModeSelector");

    _type=Mode::Dispersion;
    _defaultIndex=0;
    _defaultRingIndex=0;
  }

  /*!
    Description of destructor still missing
  */
  ModeSelector::~ModeSelector()
  {
    TRACE;
    Settings::setColumnWidth(list, "ModeSelector");
  }

  void ModeSelector::setEditable(bool e)
  {
    TRACE;
    if(e) {
      list->setEditTriggers(QAbstractItemView::AllEditTriggers);
    } else {
      list->setEditTriggers(QAbstractItemView::NoEditTriggers);
    }
    addBut->setEnabled(e);
    removeBut->setEnabled(e);
  }

  void ModeSelector::setProxy(ModalProxy * p)
  {
    TRACE;
    ModeItem * item=qobject_cast<ModeItem *>(list->model());
    item->setProxy(p);
  }

  void ModeSelector::setModeType(Mode::Type t)
  {
    TRACE;
    ModeDelegate * d=static_cast<ModeDelegate *>(list->itemDelegate());
    d->setType(t);
    ModeItem * item=qobject_cast<ModeItem *>(list->model());
    item->setType(t);
    _type=t;
  }

  void ModeSelector::on_addBut_clicked()
  {
    TRACE;
    static_cast<ModeItem *>(list->model())->add(defaultMode());
  }

  void ModeSelector::on_removeBut_clicked()
  {
    TRACE;
    QItemSelectionModel * selModel=list->selectionModel();
    static_cast<ModeItem *>(list->model())->remove(selModel);
  }

  void ModeSelector::beginModeChange()
  {
    TRACE;
    static_cast<ModeItem *>(list->model())->beginModeChange();
  }

  void ModeSelector::endModeChange()
  {
    TRACE;
    static_cast<ModeItem *>(list->model())->endModeChange();
  }

  Mode ModeSelector::defaultMode() const
  {
    TRACE;
    switch(_type) {
    case Mode::Dispersion:
      break;
    case Mode::Autocorr:
      return Mode(Mode::Vertical, _defaultRingIndex, _defaultIndex);
    case Mode::Ellipticity:
      return Mode(Mode::Signed, _defaultIndex);
    }
    return Mode(Mode::Phase, Mode::Rayleigh, _defaultIndex);
  }

} // namespace QGpGuiWave
