/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiWave.h>
#include <SciFigs.h>

#include "ModalPlotProxy.h"
#include "ModalLine.h"

namespace QGpGuiWave {

/*!
  \class ModalPlotProxy ModalPlotProxy.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

  /*!
    Titles are already set.
  */
  void ModalPlotProxy::setXAxisProperties(Axis * a)
  {
    TRACE;
    a->setRange(0.1,100);
    a->setScaleType(Scale::Log);
  }

  /*!
    Titles are already set.
  */
  void ModalPlotProxy::setYAxisProperties(Axis * a)
  {
    TRACE;
    a->setRange(0.0, 5.0);
  }

  void ModalPlotProxy::setCurve(AbstractLine * line, CurveProxy * proxy)
  {
    TRACE;
    static_cast<ModalProxy *>(proxy)->setCurve(&static_cast<ModalLine *>(line)->curve());
  }

} // namespace QGpGuiWave
