/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-07-19
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROGRESSBAR_H
#define PROGRESSBAR_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT ProgressBar : public QProgressBar, public AbstractProgress
  {
    Q_OBJECT
  public:
    ProgressBar(QWidget * parent);

    inline void setValue(qint64 val);
    int value() const {return AbstractProgress::value();}

    virtual inline void setMaximum(qint64 val);
    int maximum() const {return AbstractProgress::maximum();}

    void show() {QProgressBar::show();}
  protected:
    virtual void paint(QString, qint64 value, qint64) {QProgressBar::setValue(value);}
  private:
    void beginSubProgress(qint64 val);
    void endSubProgress();

    class State {
    public:
      State(qint64 val=0, qint64 max=0) {value=val; maximum=max;}
      qint64 value, maximum;
    };
    QStack<State> _states;
  };

  inline void ProgressBar::setMaximum(qint64 val)
  {
    beginSubProgress(val);
  }

  inline void ProgressBar::setValue(qint64 val)
  {
    AbstractProgress::setValue(val);
    if(val==maximum()) {
      endSubProgress();
    }
  }

} // namespace QGpGuiTools

#endif // PROGRESSBAR_H
