/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-11
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLUMNTEXTITEM_H
#define COLUMNTEXTITEM_H

#include <QtGui>
#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT ColumnTextItem : public QAbstractItemModel
{
  Q_OBJECT
public:
  ColumnTextItem(QObject * parent=nullptr);
  ~ColumnTextItem();

  void setParser(ColumnTextParser * p);

  virtual int rowCount(const QModelIndex &parent=QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent=QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual bool setData(const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const;
  virtual QModelIndex parent (const QModelIndex & index) const;
  virtual QModelIndex index (int row, int column, const QModelIndex & parent=QModelIndex()) const;
  virtual Qt::ItemFlags flags (const QModelIndex & index) const;
signals:
  void typeChanged();
private slots:
  void rowsAboutToBeParsed();
  void rowsParsed();
private:
  ColumnTextParser * _parser;
};

} // namespace QGpGuiTools

#endif // COLUMNTEXTITEM_H
