/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-02-17
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CheckComboBoxModel.h"

namespace QGpGuiTools {

  /*!
    \class CheckComboBoxModel CheckComboBoxModel.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  CheckComboBoxModel::CheckComboBoxModel(QObject * parent)
    : QAbstractListModel(parent)
  {
  }

  /*!
    Description of destructor still missing
  */
  CheckComboBoxModel::~CheckComboBoxModel()
  {
  }

  int CheckComboBoxModel::rowCount(const QModelIndex &) const
  {
    return _items.count();
  }

  int CheckComboBoxModel::columnCount(const QModelIndex &) const
  {
    return 1;
  }

  QVariant CheckComboBoxModel::data(const QModelIndex &index, int role) const
  {
    TRACE;
    switch (role) {
    case Qt::CheckStateRole:
      return _items.at(index.row()).second ? Qt::Checked : Qt::Unchecked;
    case Qt::DisplayRole:
      return _items.at(index.row()).first;
    default:
      return QVariant();
    }
  }

  bool CheckComboBoxModel::setData(const QModelIndex & index, const QVariant & value, int role)
  {
    TRACE;
    switch (role) {
    case Qt::CheckStateRole:
      _items[index.row()].second=(value.toInt()==Qt::Checked);
      emit valueChanged();
      return true;
    default:
      return false;
    }
  }

  Qt::ItemFlags CheckComboBoxModel::flags(const QModelIndex &) const
  {
    return Qt::ItemIsEnabled | Qt::ItemIsSelectable | Qt::ItemIsEditable;
  }

  void CheckComboBoxModel::addItems(const QStringList& items)
  {
    for(QStringList::const_iterator it=items.begin(); it!=items.end(); it++) {
      _items.append(QPair<QString, bool>(*it, false));
    }
  }

  void CheckComboBoxModel::setCurrentItems(const QString& items)
  {
    beginResetModel();
    QStringList itemStrings=items.split(",");
#if(QT_VERSION >= QT_VERSION_CHECK(5, 14, 0))
    QSet<QString> is(itemStrings.begin(), itemStrings.end());
#else
    QSet<QString> is=QSet<QString>::fromList(items.split(","));
#endif
    for(QList<QPair<QString, bool> >::iterator it=_items.begin(); it!=_items.end(); it++) {
      QPair<QString, bool>& p=*it;
      p.second=is.contains(p.first);
    }
    endResetModel();
    emit valueChanged();
  }

  QString CheckComboBoxModel::currentText() const
  {
    QString t;
    for(QList<QPair<QString, bool> >::const_iterator it=_items.begin(); it!=_items.end(); it++) {
      const QPair<QString, bool>& p=*it;
      if(p.second) {
        if(t.isEmpty()) {
          t=p.first;
        } else {
          t+=",";
          t+=p.first;
        }
      }
    }
    return t;
  }

  void CheckComboBoxModel::toggleItem(int index)
  {
    QPair<QString, bool>& p=_items[index];
    beginResetModel();
    p.second=!p.second;
    endResetModel();
    emit valueChanged();
  }

} // namespace QGpGuiTools
