/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-02-03
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef THEORETICALLINEARFK_H
#define THEORETICALLINEARFK_H

#include <QGpCoreTools.h>
#include "TheoreticalFK.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT TheoreticalLinearFK : public TheoreticalFK
{
public:
  TheoreticalLinearFK(const QVector<Point2D>& stations) : TheoreticalFK(stations) {_threshold=0.5;}

  void setRadians(double a) {_angle.setRadians(a);}
  void setAzimuth(double a) {_angle.setDegreeAzimuth(a);}
  void setAngle(const Angle& a) {_angle=a;}
  const Angle& angle() const {return _angle;}

  void setThreshold(double t) {_threshold=t;}
  double threshold() const {return _threshold;}

  inline double value(double k) const;
  inline double y(double k) {return value(k)-_threshold;}
private:
  Angle _angle;
  double _threshold;
};

inline double TheoreticalLinearFK::value(double k) const
{
  TRACE;
  return TheoreticalFK::value(Point(k*_angle.cos(), k*_angle.sin()));
}

} // namespace QGpCoreWave

#endif // THEORETICALLINEARFK_H
