/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-20
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAGNETOTELLURICCURVE_H
#define MAGNETOTELLURICCURVE_H

#include <QGpCoreTools.h>

#include "MagnetoTelluricPoint.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

  class MagnetoTelluricFactory;

  class QGPCOREWAVE_EXPORT MagnetoTelluricCurve : public Curve<MagnetoTelluricPoint>, public XMLClass
  {
  public:
    MagnetoTelluricCurve() {}
    inline MagnetoTelluricCurve(const MagnetoTelluricCurve& o);
    //MagnetoTelluricCurve(int n) : Curve<ComplexStatisticalPoint>(n) {}
    //inline MagnetoTelluricCurve(const Curve<ComplexStatisticalPoint>& o);
    //~MagnetoTelluricCurve();

    inline bool operator==(const MagnetoTelluricCurve& o) const;
    //void operator=(const Curve<ComplexStatisticalPoint>& o);

    virtual const QString& xml_tagName() const {return xmlMagnetoTelluricCurveTag;}
    static const QString xmlMagnetoTelluricCurveTag;

    void clear();
    void linkX(const ::QVector<double>& x);

    void setName(QString n) {_name=n;}
    QString name() const {return _name;}

    void addLog(QString s) {_log+=s;}
    QString log() const {return _log;}

    double misfit(int& nValues, int& nData, const MagnetoTelluricFactory& f, MisfitType type, double minMisfit) const;
  protected:
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
    XMLMember xml_member(XML_MEMBER_ARGS);
    bool xml_setProperty(XML_SETPROPERTY_ARGS);
  private:
    QString _name;
    QString _log;
  };

  inline bool MagnetoTelluricCurve::operator==(const MagnetoTelluricCurve& o) const
  {
    return _name==o._name &&
           _log==o._log &&
           Curve<MagnetoTelluricPoint>::operator==(o);
  }

  inline MagnetoTelluricCurve::MagnetoTelluricCurve(const MagnetoTelluricCurve& o)
    : Curve<MagnetoTelluricPoint>(o), XMLClass()
  {
    _name=o._name;
    _log=o._log;
  }

} // namespace QGpCoreWave

#endif // MAGNETOTELLURICCURVE_H
