/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-22
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AUTOCORRCURVES_H
#define AUTOCORRCURVES_H

#include <QGpCoreTools.h>
#include "AutocorrRing.h"
#include "ModalCurve.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT AutocorrCurves : public XMLClass
{
  TRANSLATIONS("AutocorrCurves")
public:

  virtual const QString& xml_tagName() const {return xmlAutocorrCurvesTag;}
  static const QString xmlAutocorrCurvesTag;

  bool isEmpty() const {return _curves.isEmpty();}
  int ringCount() const {return _rings.count();}
  void addRing() {addRing(AutocorrRing());}
  void addRing(const AutocorrRing& r);
  void removeRing(int index);
  void add(const AutocorrCurves& curves);
  void add(const ModalCurve& c);

  const AutocorrRing& ring(int index) const {return _rings[index];}
  AutocorrRing& ring(int index) {return _rings[index];}
  int indexOf(const AutocorrRing& r) const {return _rings.indexOf(r);}
  const QVector<AutocorrRing> * rings() const {return &_rings;}

  const QList<ModalCurve>& curves() const {return _curves;}
  QList<ModalCurve>& curves() {return _curves;}
  ModalCurve& lastCurve() {return _curves.last();}
  ModalCurve dispersionCurve(int index, double kmin, double kmax, int maxSolutionCount) const;
  double firstBesselMinimum(int index) const;

  QList<ModalCurve> ringCurves(int index) const;
protected:
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
  bool xml_polish(XML_POLISH_ARGS);
private:
  QList<ModalCurve> _curves;
  QVector<AutocorrRing> _rings;
};

} // namespace QGpCoreWave

#endif // AUTOCORRCURVES_H
