/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-12-19
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HISTOGRAM_H
#define HISTOGRAM_H

#include "QGpCoreStatDLLExport.h"
#include "Curve.h"
#include "Rect.h"
#include "StatisticalValue.h"

namespace QGpCoreStat {


  class QGPCORESTAT_EXPORT Histogram : public Curve<Point2D>
  {
  public:
    inline Histogram(const Histogram& o);
    inline Histogram(const Curve<Point2D>& o);
    ~Histogram() {}

    void setSampling(SamplingOptions sampling) {_sampling=sampling;}
    SamplingOptions sampling() const {return _sampling;}

    double normalize();
    Curve<Point2D> cumulative() const;

    RealStatisticalValue mean() const;
    RealStatisticalValue median() const;
    RealStatisticalValue mode() const;

    ::QVector<RealStatisticalValue> pick(int maxCount, double range, double maxError) const;
  private:
    inline Histogram(SamplingOptions s);
    Histogram scaled() const;
    RealStatisticalValue real(double average) const;
    double variance(double average) const;
    void expand(Histogram& hist, int& i, double range) const;

    SamplingOptions _sampling;
  };

  inline Histogram::Histogram(SamplingOptions s)
    : Curve<Point2D>(), _sampling(s)
  {
  }

  inline Histogram::Histogram(const Histogram& o)
    : Curve<Point2D>(o), _sampling(o._sampling)
  {
    ASSERT(_sorted);
    ASSERT(count()>1);
  }

  inline Histogram::Histogram(const Curve<Point2D>& o)
    : Curve<Point2D>(o), _sampling(LinearScale)
  {
    ASSERT(_sorted);
    ASSERT(count()>1);
  }

} // namespace QGpCoreStat

#endif // HISTOGRAM_H
