/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-12
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Sphere.h"

namespace QGpCoreMath {

  /*!
    \class Sphere Sphere.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  Sphere::Sphere(double x0, double y0, double z0, double r)
    : _c(x0, y0, z0)
  {
    _r=fabs(r);
  }

  Sphere::Sphere(const Point &c, double r)
    : _c(c)
  {
    _r=fabs(r);
  }

  Sphere::Sphere(const  Sphere&o)
  {
    _c=o._c;
    _r=o._r;
  }

  double Sphere::distanceTo(const Point& p) const
  {
    TRACE;
    double d=p.distanceTo(_c);
    return fabs(d-_r);
  }

  bool Sphere::contains(const Point& p) const
  {
    TRACE;
    double d=p.distanceTo(_c);
    return d<=_r;
  }

} // namespace QGpCoreMath

