/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-29
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef POINTLOCATE_H
#define POINTLOCATE_H

#include "QGpCoreMathDLLExport.h"
#include "Point.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT PointLocate
{
public:
  PointLocate();
  ~PointLocate();

  void setReference(int index, const QString& s);
  void setDistance(int index, double d);
  void setAzimuth(int index, double az);
  void setDistance(int index);
  void setAzimuth(int index);
  void setSolutionIndex(int i) {_solutionIndex=i;}

  QString reference(int index) const;
  bool isDistance(int index) const;
  double distance(int index) const;
  bool isAzimuth(int index) const;
  double azimuth(int index) const;
  int solutionIndex() const {return _solutionIndex;}

  Point position(const QMap<QString, const Point *>& references, Point& uncertainty, int& nSolutions) const;

  bool fromString(const QString& log);
  QString toString() const;
private:
  void availableInformation(int& distCount, int& azimuthCount, int& id, int& iaz) const;

  QString _references[3];
  double _distances[3];
  double _azimuths[3];
  double _isDistance[3];
  double _isAzimuth[3];
  int _solutionIndex;
};

} // namespace QGpCoreMath

#endif // POINTLOCATE_H
