/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-03-02
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GridSearchTest.h"

namespace QGpCoreMath {

  /*!
    \class GridSearchTest GridSearchTest.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  GridSearchTest::GridSearchTest()
    : AbstractFunction()
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  GridSearchTest::~GridSearchTest()
  {
    TRACE;
  }

  double GridSearchTest::value(const Point& p) const
  {
    double f=0.0;
    double d;
    double exponent=0.1;
    d=Point(0.2, 0.1, 2.0).distanceTo(p);
    f+=exp(-pow(d*d, exponent));
    d=Point(0.2, 0.1, -0.5).distanceTo(p);
    f+=exp(-pow(d*d, exponent));
    d=Point(-0.3, 0.2, 2.0).distanceTo(p);
    f+=exp(-pow(d*d, exponent));
    d=Point(-0.3, 0.2, -0.5).distanceTo(p);
    f+=exp(-pow(d*d, exponent));
    return f;
  }

  double GridSearchTest::thirdMinimum() const
  {
    return -2.5;
  }

  double GridSearchTest::thirdMaximum() const
  {
    return 2.5;
  }

  double GridSearchTest::thirdStep() const
  {
    return 0.1;
  }

} // namespace QGpCoreMath

