/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FREQUENCYBAND_H
#define FREQUENCYBAND_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT FrequencyBand: public AbstractParameters
  {
  public:
    FrequencyBand();
    FrequencyBand(const FrequencyBand& o);

    virtual AbstractParameters * clone() const {return new FrequencyBand(*this);}

    inline void setCenter(double f);
    void setRelativeWidth(double w) {_relativeWidth=w;}
    double center() const {return _center;}
    double omega() const {return _omega;}
    double squaredOmega() const {return _squaredOmega;}
    double relativeWidth() const {return _relativeWidth;}
    double width() const {return 2.0*_relativeWidth*_center;}
    double halfWidth() const {return _relativeWidth*_center;}
    double lowLimit() const {return _center*(1.0-_relativeWidth);}
    double highLimit() const {return _center*(1.0+_relativeWidth);}
  private:
    double _center;
    double _relativeWidth;
    double _omega;
    double _squaredOmega;
  };

  inline void FrequencyBand::setCenter(double f)
  {
    TRACE;
    _center=f;
    _omega=2.0*M_PI*_center;
    _squaredOmega=_omega*_omega;
  }

} // namespace QGpCoreMath

#endif // FREQUENCYBAND_H
