/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-26
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COORDINATEFILE_H
#define COORDINATEFILE_H

#include <QGpCoreTools.h>

#include "NamedPoint.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT CoordinateFile : public ColumnTextFile
  {
  public:
    CoordinateFile();
    ~CoordinateFile();

    bool setFile(QString fileName=QString());

    void setNameRequired(bool r) {_nameRequired=r;}
    bool isNameRequired() const {return _nameRequired;}

    QList<NamedPoint> points() const;
    UtmZone utmZone() const;

    enum CoordinateType {Undefined, Local, UniversalTransverseMercator, Geographical};
    CoordinateType coordinateType(bool warn) const;

    static QString allFileFilter() {return _rectFileFilter+";;"+_geoFileFilter;}
    static const QString& rectFileFilter() {return _rectFileFilter;}

    static bool write(const QList<NamedPoint>& points, UtmZone utmZone,
                      Point *reference=0, QString fileName=QString());
    static UtmZone utmZone(const QList<NamedPoint> &points);
  private:
    bool _nameRequired;

    static UtmZone utmZone(const QHash<UtmZone, int> &zoneStat);
    static void toGeographicalCoordinates(NamedPoint& p, const UtmZone& utmZone, const Point *reference);

    static QStringList _types;
    static const QString _rectFileFilter;
    static const QString _geoFileFilter;
  };

} // namespace QGpCoreMath

#endif // COORDINATEFILE_H

