/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-11-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "CompatRefractionSurvey.h"
#if 0
const QString CompatRefractionSurvey::xmlRefractionSurveyTag="RefractionSurvey";

QDataStream& operator<<(QDataStream& s, const CompatRefractionSurvey& p)
{
  TRACE;
  for(int is=0;is<p.nSrc();is++) {
    const CompatSrcHodochrone& point=p.hodochrone(is);
    for(int ir=0;ir<point.nRec();ir++) {
      s << point[ir].distance();
      s << point[ir].value();
    }
  }
  return s;
}

QDataStream& operator>>(QDataStream& s, CompatRefractionSurvey& p)
{
  TRACE;
  for(int is=0;is<p.nSrc();is++) {
    CompatSrcHodochrone& point=p.hodochrone(is);
    for(int ir=0;ir<point.nRec();ir++) {
      s >> point[ir].distance();
      s >> point[ir].value();
    }
  }
  return s;
}

void CompatRefractionSurvey::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  char buf[16];
  for(int is=0;is<nSrc();is++) {
    sprintf(buf,"src=\"%i\"",is);
    (*this)[is].xml_save(s,buf);
  }  
}
    
XMLMember CompatRefractionSurvey::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  if(tag=="SrcHodoChrone") {
    static const QString tmp("src");
    XMLRestoreAttributeIterator it=map.find(tmp);
    if(it!=map.end()) {
      int is=it.value().toInt();
      if(is<nSrc()) return (XMLClass *)(&hodochrone(is));
      else {
        App::log(tr("Src index %1 out of range, max=%2\n\n").arg(is).arg(nSrc()) );
        return 0;        
      }
    }    
    else {
      App::log(tr("Attribute src not found\n") );
      return 0;              
    }
  }
  else return 0;  
}
#endif
