/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-20
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATREFRAREPORT_H
#define COMPATREFRAREPORT_H

#include <QGpCoreWave.h>

#include "CompatInversionReport.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

class CompatHodoChrone;
class CompatHodoChroneData;

class QGPCOMPATIBILITY_EXPORT CompatRefraReport :  public CompatInversionReport
{
public:
  CompatRefraReport(bool isWrite, QString reportFile, QString naInFile=QString(), int nModels=0);
  ~CompatRefraReport();
  /// Test whether this class is of type className
  virtual bool isA(const char * className);
  void addRefraGoal(CompatHodoChroneData *hd);
  /**
     Re-writing over the existing goal curves, extrem caution may be observe to
     the size of the new CompatHodoChroneData: it must be exactly the same structure as the
     one added with addRefraGoal(), only some changes in the values are tolerated
  */
  void modifyRefraGoal(CompatHodoChroneData * rms);
  CompatHodoChroneData * loadRefraGoal();
  /// load the model, the cost, the hodochrone curve
  void loadRefra(int modelIndex);
  void loadRefra(CompatHodoChrone * hodo,int modelIndex);
  /// Returns the autocorr curves of current model
  CompatHodoChrone * currentHodoChrone();
  RefractionDippingModel * currentTiltModel();
protected:
  RefractionDippingModel * _currentTiltModel;
  void initCurrentTiltModel();
  /// initialize current dispersion object
  virtual bool initCurrentDispersion();
};

inline CompatHodoChrone * CompatRefraReport::currentHodoChrone()
{
  TRACE;
  if(!_currentDispersion) loadRefra(0);  
  return (CompatHodoChrone *)_currentDispersion;
}

inline RefractionDippingModel * CompatRefraReport::currentTiltModel()
{
  TRACE;
  if(!_currentTiltModel) initCurrentTiltModel();  
  return _currentTiltModel;
}

} // namespace QGpCompatibility

#endif // COMPATREFRAREPORT_H
