/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-30
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "StudentTestCurveModel.h"

namespace HVGui {

  /*!
    \class StudentTestCurveModel StudentTestCurveModel.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  StudentTestCurveModel::StudentTestCurveModel(QObject * parent)
    : QAbstractItemModel(parent)
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  StudentTestCurveModel::~StudentTestCurveModel()
  {
    TRACE;
  }

  void StudentTestCurveModel::setList(const StudentTest::ResultLists& curves)
  {
    TRACE;
    _curves=curves;
    _lists=curves.keys();
  }

  int StudentTestCurveModel::rowCount(const QModelIndex& parent) const
  {
    TRACE;
    if(parent.isValid()) {
      if(parent.internalId()>=0) {
        return 0;
      } else {
        return _curves.value(_lists.at(parent.row())).count();
      }
    } else {
      return _curves.count();
    }
  }

  int StudentTestCurveModel::columnCount(const QModelIndex&) const
  {
    TRACE;
    return 1;
  }

  QVariant StudentTestCurveModel::data(const QModelIndex& index, int role) const
  {
    TRACE;
    if(role==Qt::DisplayRole || role==Qt::ToolTipRole) {
      CurveResults * res=results(index);
      if(res) {
        return res->name();
      } else {
        return _lists.at(index.row());
      }
    }
    return QVariant();
  }

  QModelIndex StudentTestCurveModel::parent(const QModelIndex& index) const
  {
    TRACE;
    if(!index.isValid()) {
      return QModelIndex();
    } else {
      if(index.internalId()<0) {
        return QModelIndex();
      } else {
        return createIndex(index.internalId(), 0, -1);
      }
    }
  }

  QModelIndex StudentTestCurveModel::index (int row, int column, const QModelIndex& parent) const
  {
    TRACE;
    if(parent.isValid()) {
      return createIndex(row, column, parent.row());
    } else {
      return createIndex(row, column, -1);
    }
  }

  Qt::ItemFlags StudentTestCurveModel::flags(const QModelIndex& index) const
  {
    TRACE;
    if(index.internalId()<0) {
      return Qt::ItemIsEnabled;
    } else {
      return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
    }
  }

  CurveResults * StudentTestCurveModel::results(const QModelIndex& index) const
  {
    if(index.internalId()<0) {
      return nullptr;
    } else {
      return _curves.value(_lists.at(index.parent().row())).at(index.row());
    }
  }

} // namespace HVGui
