/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "RotateResultWidget.h"

namespace HVGui {

  /*!
    \class RotateResultWidget RotateResultWidget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  RotateResultWidget::RotateResultWidget(QWidget * parent)
    : AbstractResultWidget(parent)
  {
    TRACE;

    AxisWindow * g=new AxisWindow;
    g->setObjectName("result");
    g->setAnchor(GraphicObject::TopRight);
    g->xAxis()->setFrequency();
    g->yAxis()->setNumberType('f');
    g->yAxis()->setTitle("Azimuth (deg.)");

    _gridLayer=new IrregularGrid2DPlot(g);
    _gridLayer->setObjectName("rotated");

    g->setGeometry(9.0, 1.0, 7.5, 7.5, Axis::AxisSize);
    addObject(g);
  }

  /*!
    Description of destructor still missing
  */
  RotateResultWidget::~RotateResultWidget()
  {
    TRACE;
  }

  void RotateResultWidget::setLimits(const SamplingParameters& x)
  {
    TRACE;
    AxisWindow * g=_gridLayer->graph();
    g->xAxis()->setRange(x.minimum(), x.maximum());
    g->yAxis()->setRange(0.0, 180.0);
  }

  void RotateResultWidget::restoreMakeUp(const QString& fileName)
  {
    TRACE;
    AxisWindow * g=_gridLayer->graph();
    return g->restoreMakeUp(fileName);
  }

  void RotateResultWidget::showValues()
  {
    TRACE;
    AxisWindow * g=_gridLayer->graph();
    _gridLayer->setGrid(values()->grid());
    g->deepUpdate();
  }

} // namespace HVGui

