/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-10
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <SciFigs.h>

#include "CurveResultSheetOptions.h"
#include "CurveResultWidget.h"

namespace HVGui {

  CurveResultSheetOptions::CurveResultSheetOptions(QWidget *parent, Qt::WindowFlags f)
      : QWidget(parent, f)
  {
    TRACE;
    setupUi(this);
  }

  QCheckBox * CurveResultSheetOptions::checkBox(int iLayer) const
  {
    TRACE;
    switch (iLayer) {
    case 0: return t10;
    case 1: return frequencyPeaks;
    case 2: return allWindows;
    case 4: return stddev;
    case 5: return noiseModel;
    default: return average;
    }
  }

  void CurveResultSheetOptions::setChecked(int ilayer, bool visible)
  {
    TRACE;
    checkBox(ilayer)->setChecked(visible);
  }

  bool CurveResultSheetOptions::isChecked(int ilayer) const
  {
    TRACE;
    return checkBox(ilayer)->isChecked();
  }

  void CurveResultSheetOptions::visibleLayers(const CurveResultWidget * r) const
  {
    TRACE;
    r->t10Layer()->setOpacity(isChecked(0) ? 1.0 : 0.0);
    r->peakLayer()->setOpacity(isChecked(1) ? 1.0 : 0.0);
    r->windowsLayer()->setOpacity(isChecked(2) ? 1.0 : 0.0);
    r->averageLayer()->setOpacity(isChecked(3) ? 1.0 : 0.0);
    r->stddevLayer()->setOpacity(isChecked(4) ? 1.0 : 0.0);
    if(r->noiseModelLayer()) {
      r->noiseModelLayer()->setOpacity(isChecked(5) ? 1.0 : 0.0);
    }
  }

  void CurveResultSheetOptions::setVisibleLayers(const CurveResultWidget * r)
  {
    TRACE;
    setChecked(0, r->t10Layer()->opacity()>0.0);
    setChecked(1, r->peakLayer()->opacity()>0.0);
    setChecked(2, r->windowsLayer()->opacity()>0.0);
    setChecked(3, r->averageLayer()->opacity()>0.0);
    setChecked(4, r->stddevLayer()->opacity()>0.0);
    if(r->noiseModelLayer()) {
      setChecked(5, r->noiseModelLayer()->opacity()>0.0);
      noiseModel->show();
    } else {
      noiseModel->hide();
    }
  }

  int CurveResultSheetOptions::visibleLayers() const
  {
    TRACE;
    int v=0;
    int flag=0x01;
    for(int i=0;i < 6;i++ ) {
      if(isChecked(i)) v|=flag;
      flag=flag << 1;
    }
    return v;
  }

  void CurveResultSheetOptions::setVisibleLayers(int v)
  {
    TRACE;
    int flag=0x01;
    for(int i=0; i < 6; i++) {
      setChecked(i, v & flag);
      flag=flag << 1;
    }
  }

} // namespace HVGui
