/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTSUMMARY_H
#define ABSTRACTSUMMARY_H

#include <SciFigs.h>
#include <HVCore.h>

#include "HVGuiDLLExport.h"
#include "StationLine.h"

namespace HVGui {

  class SummaryMapOptions;

  class HVGUI_EXPORT AbstractSummary : public GraphicSheetMenu
  {
    Q_OBJECT
  public:
    AbstractSummary(QWidget* parent=nullptr);
    ~AbstractSummary();

    virtual void setWindowTitle(QString subPoolName)=0;
    virtual void addActions();
    virtual void setResults(const QList<AbstractResults *>& results);
    QMenu * menuTools;

    void setValueTitle(const QString& t);
  public slots:
    virtual void setLimits();
  private slots:
    void pickGridMaxima(bool on);
    void autoPickGridMaximum();
    void gridCrossSection();
    void mapOptions();
    void setMapOptions();
    void editPeaks();
  protected:
    QMap<double, CurveResults *> distance2Station();

    virtual void createGraphs(bool multiStations)=0;
    void createStackedGraph(double x, double y);
    void createAverageGraph(double x, double y);
    void createSpectrumGridGraph(double x, double y);
    void createGridCrossSectionGraph(double x, double y);
    void createBubbleGraph(double x, double y);

    virtual void setValues(const QMap<double, CurveResults *> * dist2stat=nullptr)=0;
    void setStackedValues();
    void setAverageValues();
    void setAveragePeak();
    void updateAveragePeaks();
    void setSpectrumGridValues(const QMap<double, CurveResults *> * dist2stat);
    void setBubbleValues();

    LineLayer * stackedLayer() const {return _stackedLayer;}
    LineLayer * averageLayer() const {return _averageLayer;}
    IrregularGrid2DPlot * spectrumGridLayer() const {return _spectrumGridLayer;}
    GridMaxFollower * spectrumGridMaxLayer() const {return _spectrumGridMaxLayer;}
    LineLayer * gridCrossSectionLayer() const {return _gridCrossSectionLayer;}
    XYValuePlot * bubbleLayer() const {return _bubbleLayer;}
    NameLineLayer * bubbleNameLayer() const {return _bubbleNameLayer;}
  private:
    LineLayer * _stackedLayer;
    LineLayer * _averageLayer;
    ParallelBands * _averagePeakLayer;
    IrregularGrid2DPlot * _spectrumGridLayer;
    GridMaxFollower * _spectrumGridMaxLayer;
    LineLayer * _gridCrossSectionLayer;
    ColorMapWidget * _spectrumGridPalette;
    XYValuePlot * _bubbleLayer;
    NameLineLayer * _bubbleNameLayer;
    ColorMapWidget * _bubblePalette;

    QList<CurveResults *> _results;
    // Options
    StationLine::Label _mapLabels;
    StationLine::PeakSelection _mapPeakSelection;
    CurveResults::PeakValue _mapPeakValue;
    int _mapPeakValueDecimals;
    int _mapPeakIndex;
    bool _mapShowBubbles;
    Legend _categories;
    QVector<RealStatisticalValue> _peaks;
    SummaryMapOptions * _mapOptions;

  };

} // namespace HVGui

#endif // ABSTRACTSUMMARY_H
