/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTRESULTWIDGET_H
#define ABSTRACTRESULTWIDGET_H

#include <SciFigs.h>
#include <HVCore.h>

#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT AbstractResultWidget : public GraphicObjectGroup
  {
  public:
    AbstractResultWidget(QWidget * parent=nullptr);
    ~AbstractResultWidget();

    virtual void setValueTitle(const QString& t);
    virtual void restoreMakeUp(const QString& fileName)=0;

    void setCategory(const QString& c);

    virtual void setValues(AbstractResults * res);
    AbstractResults * values() const {return _values;}
    virtual void showValues() {}
  protected:
    AbstractResults * _values;
    TextEdit * _label;
  };

} // namespace HVGui

#endif // ABSTRACTRESULTWIDGET_H

