/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-11-24
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FrequencyWindowRejection.h"

namespace HVCore {

  /*!
    \class FrequencyWindowRejection FrequencyWindowRejection.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  FrequencyWindowRejection::FrequencyWindowRejection()
    : AbstractParameters()
  {
    TRACE;
    _minimumFrequency=0.0001;
    _maximumFrequency=5000.0;
    _stddevFactor=2;
    _maximumIterationCount=50;
  }

  FrequencyWindowRejection::FrequencyWindowRejection(const FrequencyWindowRejection& o)
    : AbstractParameters(o)
  {
    TRACE;
    _minimumFrequency=o._minimumFrequency;
    _maximumFrequency=o._maximumFrequency;
    _stddevFactor=o._stddevFactor;
    _maximumIterationCount=o._maximumIterationCount;
  }

  void FrequencyWindowRejection::checkFrequencyRange()
  {
    TRACE;
    if(_minimumFrequency>_maximumFrequency) {
      std::swap(_minimumFrequency, _maximumFrequency);
    }
  }

  int FrequencyWindowRejection::keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const
  {
    return 4+AbstractParameters::keywordCount();
  }

  void FrequencyWindowRejection::collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS)
  {
    TRACE;
    int baseIndex=AbstractParameters::keywordCount();
    QString localPrefix=prefix+"FREQUENCY_WINDOW_REJECTION_";
    keywords.add(localPrefix+"MINIMUM_FREQUENCY"+suffix, this, baseIndex);
    keywords.add(localPrefix+"MAXIMUM_FREQUENCY"+suffix, this, baseIndex+1);
    keywords.add(localPrefix+"STDDEV_FACTOR"+suffix, this, baseIndex+2);
    keywords.add(localPrefix+"MAXIMUM_ITERATIONS"+suffix, this, baseIndex+3);
  }

  bool FrequencyWindowRejection::setValue(PARAMETERS_SETVALUE_ARGS)
  {
    TRACE;
    bool ok=true;
    switch(index-AbstractParameters::keywordCount()) {
    case 0:
      setMinimumFrequency(value.toDouble(&ok));
      return ok;
    case 1:
      setMaximumFrequency(value.toDouble(&ok));
      return ok;
    case 2:
      setStddevFactor(value.toDouble(&ok));
      return ok;
    case 3:
      setMaximumIterationCount(value.toInt(&ok));
      return ok;
    default:
      break;
    }
    return AbstractParameters::setValue(index, value, unit, keywords);
  }

  QString FrequencyWindowRejection::toString(PARAMETERS_TOSTRING_ARGS_IMPL) const
  {
    TRACE;
    QString log;
    QString localPrefix=prefix+"FREQUENCY_WINDOW_REJECTION_";
    log+="# Frequency domain window rejection (Cox et al. (2020, GJI)\n";
    log+=localPrefix+"MINIMUM_FREQUENCY"+suffix+"="+QString::number(_minimumFrequency)+"\n";
    log+=localPrefix+"MAXIMUM_FREQUENCY"+suffix+"="+QString::number(_maximumFrequency)+"\n";
    log+=localPrefix+"STDDEV_FACTOR"+suffix+"="+QString::number(_stddevFactor)+"\n";
    log+=localPrefix+"MAXIMUM_ITERATIONS"+suffix+"="+QString::number(_maximumIterationCount)+"\n";
    return log;
  }

} // namespace HVCore

