/***************************************************************************
**
**  This file is part of GeopsySLinkGui.
**
**  GeopsySLinkGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLinkGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKLOADER_H
#define SEEDLINKLOADER_H

#include <GeopsySLink.h>

#include "ui_SeedLinkLoader.h"
#include "GeopsySLinkGuiDLLExport.h"

namespace GeopsySLinkGui {

class GEOPSYSLINKGUI_EXPORT SeedLinkLoader : public QWidget, private Ui::SeedLinkLoader
{
  Q_OBJECT
public:
  SeedLinkLoader(QWidget * parent=nullptr);
  ~SeedLinkLoader();

  void setCurrentDatabase(SignalDatabase * db) {_seedLink->setCurrentDatabase(db);}

  void removeOptions();
  void removeView();

  void setServer(QString serverAddress, int serverPort);
  void selectStreams(QString selection);

  SeedLink * seedLink() {return _seedLink;}
private slots:
  void on_selectBut_clicked();
  void on_connectBut_clicked();
  void on_startBut_clicked();
  void on_stopBut_clicked();
  void on_viewBut_clicked();
  void on_optionsBut_clicked();
  void streamInfoAvailable();
  void seedLinkError(GeopsySLink::SeedLink::Error e);
  void showContextMenu(const QPoint & pos);
  void beginSignalChange(Signal * sig);
  void endSignalChange(Signal * sig);
signals:
  void started();
  void stopped();
private:
  void setStreamsEnabled(bool b);
  bool isAnySelected();

  SeedLink * _seedLink;
  QString _streamSelection;
};

} // namespace GeopsySLinkGui

#endif // SEEDLINKLOADER_H
