/***************************************************************************
**
**  This file is part of GeopsySLink.
**
**  GeopsySLink is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLink is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-24
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKSTREAM_H
#define SEEDLINKSTREAM_H

#include <GeopsyCore.h>

#include "GeopsySLinkDLLExport.h"

namespace GeopsySLink {

class SeedLinkStation;

class GEOPSYSLINK_EXPORT SeedLinkStream : public XMLClass
{
  TRANSLATIONS("SeedLinkStream")
public:
  SeedLinkStream(SeedLinkStation * station);

  enum BufferType {Unlimited, CreateNew, Rotate};

  virtual const QString& xml_tagName() const {return xmlSeedLinkStreamTag;}
  static const QString xmlSeedLinkStreamTag;

  SeedLinkStation * station() const {return _station;}

  QByteArray tag() const {return _tag;}
  void setTag();

  virtual void xml_attributes(XML_ATTRIBUTES_ARGS) const;
  virtual bool xml_setAttributes(XML_SETATTRIBUTES_ARGS);

  QString location() const {return _location;}
  void setLocation(QString l) {_location=l;}

  QString seedName() const {return _seedName;}
  void setSeedName(QString n) {_seedName=n;}

  QString type() const {return _type;}
  void setType(QString t) {_type=t;}

  QString beginTime() const {return _beginTime;}
  QString endTime() const {return _endTime;}
  int beginRecNo() const {return _beginRecNo;}
  int endRecNo() const {return _endRecNo;}
  bool gapCheck() const {return _gapCheck;}
  int gapThreshold() const {return _gapThreshold;}

  DynamicSignal * signal() const {return _signal;}
  void initSignal(const DateTime& t, double samplingFrequency);
  void detachSignal() {_signal=nullptr;}
  void set(const DateTime& t, int * samples, int nSamples, BufferType bt, double maxTime=0.0);

  bool listening() const {return _listening;}
  bool setListening(bool l) {return _listening=l;}
private:
  bool createSignal();

  SeedLinkStation * _station;

  QString _location;
  QString _seedName;
  QString _type;
  QString _beginTime;
  QString _endTime;
  int _beginRecNo;
  int _endRecNo;
  int _gapThreshold;
  bool _gapCheck;
  bool _listening;
  QByteArray _tag;

  DynamicSignal * _signal;
};

} // namespace GeopsySLink

#endif // SEEDLINKSTREAM_H
