/***************************************************************************
**
**  This file is part of GeopsyLand.
**
**  GeopsyLand is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyLand is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-12-03
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "MainWindow.h"

/*!
  \class MainWindow MainWindow.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MainWindow::MainWindow(QWidget * parent)
  : QWidget(parent)
{
  TRACE;
  setupUi(this);
  terminal->addPath(CoreApplication::applicationDirPath());

  addGeopsyApps();
}

/*!
  Description of destructor still missing
*/
MainWindow::~MainWindow()
{
  TRACE;
}

void MainWindow::addGeopsyApps()
{
  TRACE;
  appList->addItem(new QListWidgetItem(QIcon(":geopsy.png"), "geopsy"));
  appList->addItem(new QListWidgetItem(QIcon(":app.png"), "dinver"));
  appList->addItem(new QListWidgetItem(QIcon(":figue.png"), "figue"));
  appList->addItem(new QListWidgetItem(QIcon(":app.png"), "gpviewmax"));
  appList->addItem(new QListWidgetItem(QIcon(":app.png"), "gphistogram"));
  appList->addItem(new QListWidgetItem(QIcon(":app.png"), "spac2disp"));
  appList->addItem(new QListWidgetItem(QIcon(":app.png"), "gpfksimulator"));
  appList->addItem(new QListWidgetItem(QIcon(":app.png"), "waran"));
  appList->addItem(new QListWidgetItem(QIcon(":app.png"), "warangps"));
  appList->addItem(new QListWidgetItem(QIcon(":app.png"), "gpviewdcreport"));
}

void MainWindow::on_appList_itemDoubleClicked(QListWidgetItem *item)
{
  TRACE;
  QString cmd=item->text();
  QProcess p;
  p.setProgram(cmd);
#if(QT_VERSION >= QT_VERSION_CHECK(5, 10, 0))
  p.startDetached();
#else
  Message::warning(MSG_ID, tr("Start external application"),
                   tr("startDetached not supported by Qt<5.10"));
  p.start();
#endif
}
